/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.CommandLogEvent;
import apiipc.generated.events.CommandLogEventListener;
import apiipc.generated.system.CommandLog;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLogEventRegistry
extends IPCEventRegistry {
    protected Set<CommandLogEventListener> globalListeners = new HashSet<CommandLogEventListener>();
    protected Map<String, Set<CommandLogEventListener>> specificObjectListeners = new HashMap<String, Set<CommandLogEventListener>>();

    public CommandLogEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "CommandLog";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        CommandLogEvent.EntryAdded entryAdded = null;
        if (!string.equalsIgnoreCase("entryAdded")) {
            return;
        }
        entryAdded = new CommandLogEvent.EntryAdded(iPCEventLTV);
        for (CommandLogEventListener object : this.globalListeners) {
            object.handleEvent(entryAdded);
        }
        System.out.println("UUID = " + entryAdded.objectUUID);
        Set<CommandLogEventListener> set = this.specificObjectListeners.get(entryAdded.objectUUID.toString());
        System.out.println("specificListeners  = " + set);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                CommandLogEventListener commandLogEventListener = (CommandLogEventListener)iterator.next();
                commandLogEventListener.handleEvent(entryAdded);
            }
        }
    }

    public void addListenerFiltered(CommandLogEventListener commandLogEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("entryAdded");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(commandLogEventListener);
    }

    public void addSpecificListenerFiltered(CommandLogEventListener commandLogEventListener, CommandLog commandLog, List<String> list) throws IOException {
        UUID uUID = commandLog.getObjectUUID();
        String string = uUID.toString();
        System.out.println("Specific uuid = " + string);
        Set<CommandLogEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<CommandLogEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "entryAdded");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        set.add(commandLogEventListener);
        System.out.println("Specific listeners = " + set);
    }

    public void removeListenerFiltered(CommandLogEventListener commandLogEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.deregister("entryAdded");
                this.globalListeners.remove(commandLogEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(list.get(i));
                }
            }
        }
    }

    public void removeSpecificListenerFiltered(CommandLogEventListener commandLogEventListener, CommandLog commandLog, List<String> list) throws IOException {
        UUID uUID = commandLog.getObjectUUID();
        String string = uUID.toString();
        Set<CommandLogEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && set.isEmpty()) {
            if (list == null) {
                this.deregister(uUID, "entryAdded");
                set.remove(commandLogEventListener);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.deregister(uUID, list.get(i));
                }
            }
        }
    }

    public void addListener(CommandLogEventListener commandLogEventListener) throws IOException {
        this.addListenerFiltered(commandLogEventListener, null);
    }

    public void addListener(CommandLogEventListener commandLogEventListener, CommandLog commandLog) throws IOException {
        this.addSpecificListenerFiltered(commandLogEventListener, commandLog, null);
    }

    public void removeListener(CommandLogEventListener commandLogEventListener) throws IOException {
        this.removeListenerFiltered(commandLogEventListener, null);
    }

    public void removeListener(CommandLogEventListener commandLogEventListener, CommandLog commandLog) throws IOException {
        this.removeSpecificListenerFiltered(commandLogEventListener, commandLog, null);
    }
}

